<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddWithdrawColumnToPapers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('papers', function (Blueprint $table) {
            $table->boolean('withdraw')->default(0);
            $table->text('withdraw_comment')->nullable();
            $table->text('copyright')->nullable();
            $table->string('copyright_file')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('papers', function (Blueprint $table) {
            $table->dropColumn('withdraw');
            $table->dropColumn('withdraw_comment');
            $table->dropColumn('copyright');
            $table->dropColumn('copyright_file');
        });
    }
}
