<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsToPaperReviewers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('paper_reviewers', function (Blueprint $table) {
            $table->string('staff_comment')->nullable();
            $table->string('staff_status')->nullable()->default('pending');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('paper_reviewers', function (Blueprint $table) {
            $table->dropColumn('staff_comment');
            $table->dropColumn('staff_status');
        });
    }
}
