<?php

// database/migrations/xxxx_xx_xx_create_papers_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePapersTable extends Migration
{
    public function up()
    {
        Schema::create('papers', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('paper_id');
            $table->string('file_path');
            $table->string('docfile_path');
            $table->string('file_format');
            $table->bigInteger('category')->unsigned();  // A BIGINT column
            $table->bigInteger('no_of_papers')->unsigned();  // A BIGINT column
            $table->decimal('payment_amount', 8, 2)->nullable();
            $table->string('payment_status')->nullable();  // 'Success' or 'Failed'
            $table->string('transaction_id')->nullable();  // 'Transaction ID'
            
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('papers');
    }
}